<?php

namespace Core\Form\Control;

/**
 * Description of BaseControl
 *
 * @author Dmitriy
 */
abstract class BaseControl implements ControlRenderInterface
{
    protected array $attributes = [];
    protected array $data = [];

    public function addAttr($name, $value)
    {
        $this->attributes[$name] = $value;
        return $this;
    }

    function getAttributes()
    {
        $attr = $this->attributes;

        if(!empty($this->data)){
            foreach ($this->data as $k => $val){
                $attr['data-' . $k] = $val;
            }

        }
        return $attr;
    }
}
