<?php

namespace Core\Form\Control;

class UploadButton extends FormField
{

    public function __construct(protected string $name, protected string $label = 'Browse... ')
    {
    }

    public function render(): string
    {
        $data = array_merge([
            'name' => $this->getName(),
            'id' => $this->getId(),
            'value' => $this->getValue(),
            'class' => $this->getClass(),
            'type' => 'file'
        ], $this->getAttributes());

        return '<span class="pull-left btn btn-primary btn-file">' . $this->label .
            \form_input($data).
            '</span>';
    }
}