<?php

namespace Core\Form\Control;

use Core\Template\Template;
use Twig\Environment;

/**
 * Description of DatePicker
 *
 * @author Dmitriy
 */
class DatePicker extends Input
{

    protected $template;
    protected $twig;
    protected $format = 'dd/mm/yy';

    function __construct($name, Template $template, Environment $twig, $value = null, $width = false)
    {
        parent::__construct($name, $value, $width);
        $this->template = $template;
        $this->twig = $twig;
    }

    public function render(): string
    {
        return '<div class="input-group date">' . parent::render() . '<span class="input-group-addon"><i class="demo-pli-calendar-4"></i></span></div>';
    }

    /**
     * @param mixed $format
     * @return DatePicker
     */
    public function setFormat(string $format)
    {
        $this->format = $format;
        return $this;
    }
}
