<?php

namespace Core\Form\Control;

use Core\Template\Template;
use Twig\Environment;
use Widgets\Jquery\ColorPicker\ColorPicker as CPicker;

/**
 * Description of ColorPicker
 *
 * @author Dmitriy
 */
class ColorPicker extends Input
{

    protected $template;
    protected $twig;

    function __construct($name, Template $template, Environment $twig, $value = null, $width = false)
    {
        parent::__construct($name, $value, $width);
        $this->template = $template;
        $this->twig = $twig;
    }

    public function render(): string
    {
        $Colorpicker = new CPicker($this->getName(), $this->template, $this->twig);
        $Colorpicker->render();
        $this->template->addStyleLink('/_diamond/diamond-cms/assets/nifty/plugins/colorpicker/bootstrap-colorpicker.min.css');

        $this->setClass('form-control');
        //$this->setId('colorpicker_' . $this->getName());

        $html = parent::render();

        return '<div id="colorpicker_' . $this->getName().'" class="input-group colorpicker-component col-sm-3">
    '.$html.'
    <span class="input-group-addon"><i style="width: 16px; height: 16px; border: 1px solid #ddd;display: inline-block" ></i></span>
</div>';
    }

    static function buildDemoColor($name, $color)
    {
        return '<span class="colorselector" id="colorSelector_' . $name .
            '"><span ' . ($color > '' ? 'style="background-color: ' . $color . '"' : '') .
            '></span></span>';
    }

}
