<?php declare(strict_types=1);

namespace Core\Console\Commands;

use Core\Application\Loader;
use Core\Security\Access;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\ArrayInput;

/**
 * Description of HelloWorldCommand
 *
 * @author Dmitriy
 */
class InstallCommand extends Command
{

    protected function configure()
    {
        $this->setName('install')
            ->setDescription('Install project, up migration and seeds');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {

        //подготовка каталогово
        $command = $this->getApplication()->find('prepare:dirs');
        $command->run(new ArrayInput([
            'command' => 'prepare:dirs'
        ]), $output);

        //подготовка пакетов
        $command = $this->getApplication()->find('prepare:packages');
        $command->run(new ArrayInput([
            'command' => 'packages:install'
        ]), $output);

        //поднятие бд
        $command = $this->getApplication()->find('db:up');
        $command->run(new ArrayInput([
            'command' => 'migration:migrate'
        ]), $output);

        //Установка базовых sql скриптов
        $con = \Propel\Runtime\Propel::getServiceContainer()->getConnection('default');
        
        $con->prepare("INSERT IGNORE INTO _user_groups (id, name, `delete`, grp_code, description) VALUES (1, 'Суперпользователь', 0, 'root', null)")->execute();
        $con->prepare("INSERT IGNORE INTO _users (id, name, email, password, activation, group_id, usr_delete) VALUES (1, 'Админ', 'admin@mail.ru', '21232f297a57a5a743894a0e4a801fc3', '', 1, 0)")->execute();
        $con->prepare("INSERT IGNORE INTO _domains (id, name, lang, domain) VALUES (1, 'etalon', 'ru', '.*')")->execute();
        $con->prepare("INSERT IGNORE INTO _templates (id, name, description, code, domain_id) VALUES (1, 'default', 'шаблон etalon', '@local/default', 1)")->execute();
        $con->prepare("INSERT IGNORE INTO _templates (id, name, description, code, domain_id) VALUES (2, 'admin', 'Шаблон админки', '@diamond/adminblank', 1)")->execute();
        $con->prepare("INSERT IGNORE INTO _templates (id, name, description, code, domain_id) VALUES (3, 'blank', 'Упрощенный', '@local/blank', 1)")->execute();
        
        $con->prepare("INSERT IGNORE INTO _pages (id, code, title, url, template, script, content, `system`, active, domain_id) VALUES (1, '', 'Главная страница', '/', '@local/default', '', 'Studio 7 CMS, Etalon Project!', 'Y', 'Y', 1);")->execute();
        $con->prepare("INSERT IGNORE INTO _pages (id, code, title, url, template, script, content, `system`, active, domain_id) VALUES (2, 'page404', 'Ошибка 404 Такой страницы не существует', '/', '@local/blank', '', '<h1>404</h1><p>Извините, запрошенная вами страница недоступна.</p>', 'Y', 'Y', 1);")->execute();
        $con->prepare("INSERT IGNORE INTO _pages (id, code, title, url, template, script, content, `system`, active, domain_id) VALUES (3, 'offline', 'На сайте ведутся технические работы', null, '@local/blank', '', '<p>Сайт временно не доступен. Зайдите чуть позже.</p>', 'Y', 'Y', 1);")->execute();
        $con->prepare("INSERT IGNORE INTO _pages (id, code, title, url, template, script, content, `system`, active, domain_id) VALUES (4, 'access', 'Данная страница закрыта от общего доступа', null, '@local/blank', '', '<p>У Вас нет прав для просмотра данной страницы</p><a href=\"../../\"> Перейти на главную</a>', 'Y', 'Y', 1);")->execute();
        $con->prepare("INSERT IGNORE INTO _pages (id, code, title, url, template, script, content, `system`, active, domain_id) VALUES (5, 'auth', 'Авторизация в административной части сайта', '".admin_path('/auth')."', '@diamond/adminblank', '', '{{module(\"Diamond.AdminAuth\")}}', 'Y', 'Y', 1);")->execute();

        //$con->prepare("INSERT INTO _casbin_rule (id, ptype, v0, v1, v2, v3, v4, v5) VALUES (1, 'p', 'root', '*', '*', '', '', '')")->execute();
        //$con->prepare("INSERT INTO _casbin_rule (id, ptype, v0, v1, v2, v3, v4, v5) VALUES (2, 'g', 'root', '*', '*', '', '', '')")->execute();


        $output->writeln('Создан пользователь административной части сайта логин: admin@mail.ru пароль: admin');

        //Настройка прав доступа
        $di = Loader::getInstance()->load('DI');
        /** @var Access $access */
        $access = $di->get(Access::class);
        $access->initRootRules();
        $output->writeln('Prepare user rules success!');

        $output->writeln("Install completed!");
    }
}
