<?php

namespace Core\Table;

use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\ActiveQuery\Criteria;

/**
 * Description of PropelDataTable
 *
 * @author Dmitriy
 */
class PropelDataTable extends SimpleTable
{

    /**
     *
     * @param type $Model
     * @param type $Column
     * @return type
     */
    protected function prepareRow($Model, $Column)
    {

        $resultReal = method_exists($Model, 'get' . $Column->getName()) ? $Model->{"get" . $Column->getName()}() : '&nbsp;';

        if (is_callable($Column->getFn()) || (is_array($Column->getFn()) and is_object($Column->getFn()[0]))) {
            $result = call_user_func($Column->getFn(), $Model);
        } else {
            $result = $resultReal;
        }


        if (isset($this->summary[$Column->getName()]) && $resultReal > 0) {
            $this->summary[$Column->getName()] += (float)$resultReal;
        }

        return $result;
    }

    /**
     * Получение записей
     *
     * @return type
     */
    protected function getRows()
    {

        $this->setNavigation();

        if (count($this->multi_sort) > 0) {
            foreach ($this->multi_sort as $sort => $order) {
                $this->criteria->{'setSortBy' . $sort}($order == 'asc' ? Criteria::DESC : Criteria::ASC);
            }
        } else {

            $this->criteria->{'setSortBy' . $this->sort}($this->order == 'asc' ? Criteria::DESC : Criteria::ASC);
        }

        return $this->repository->findByCriteria($this->criteria);;
    }

    protected function getCount()
    {

        return $query = $this->repository->count($this->criteria);
    }

}
