<?php

use DebugBar\StandardDebugBar;
use Diamond\Application\System\SystemService as statService;
use Whoops\Handler\CallbackHandler;
use FastRoute\Dispatcher;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Whoops\Handler\PrettyPageHandler;
use Whoops\Run;
use Whoops\Handler\PlainTextHandler;
use Core\Exceptions\IsRedirectResponce;

error_reporting(-1);
ini_set('display_errors', 1);

include_once 'prepare.php';

/**
 * Error handler
 */
$request = Request::createFromGlobals();
$whoops = new Run;


/**
 *  env rules
 */
if (getenv('MODE') === 'dev') {
    if ((int)getenv('LITE_DEBUG') === 1) {
        $whoops->pushHandler(new PlainTextHandler());
        \Symfony\Component\VarDumper\Dumper\CliDumper::$defaultOutput = 'php://output';
        \Symfony\Component\VarDumper\VarDumper::setHandler(function ($var) {
            $cloner = new \Symfony\Component\VarDumper\Cloner\VarCloner();
            $dumper = new \Symfony\Component\VarDumper\Dumper\CliDumper();
            $dumper->dump($cloner->cloneVar($var));
        });
    } else {


        $whoops->pushHandler(function(){ exit('sdbsh');});
        $whoops->pushHandler(new PrettyPageHandler);
    }

} else {
    ini_set('display_errors', 0);
    if (version_compare(PHP_VERSION_ID, 50300, '>=')) {
        error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT & ~E_USER_NOTICE & ~E_USER_DEPRECATED);
    } else {
        error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_USER_NOTICE);
    }
}


//Стартуем
$logger = $container->get(\Monolog\Logger::class);
/**
 * @var Diamond\Models\Stat\Stat $stat
 * @var \Diamond\Application\System\SystemService $statService
 */
$statService = $container->get(statService::class);

try{
    //проверка страницы в бане
    $statService->checkSecurity($request);

//проверка правил
    $statService->parseRules($request);
}
catch (\Core\Exceptions\TooManyRequestsException $exception){
    Response::create('429 Too Many Requests', Response::HTTP_TOO_MANY_REQUESTS)->send();
    die();
}


$code = time();
$stat = $statService->createStat($request);
$debugBar = $container->get(StandardDebugBar::class);


//сетим красивую  страницу 500
if (getenv('MODE') !== 'dev'){
    $whoops->pushHandler(new CallbackHandler(function (\Throwable $exception) use ($logger, $request, $statService, $stat, $code) {
        $code = '500-' . $code;
        $stat->setErrorMessage($code);
        $item = [
            'code' => $code,
            'uri' => $request->getUri(),
            'method' => $request->getMethod(),
            'request' => json_encode($request->request->all()),
            'query' => json_encode($request->query->all()),
            'user' => sprintf("%s [%s]", $request->getClientIp(), $request->headers->get('user-agent')),
            'file' => $exception->getFile(),
            'line' => $exception->getLine(),
            'trace' => $exception->getTraceAsString()
        ];

        $logger->error($exception->getMessage(), $item);

        $content = "<body style='background-color: #fff'><img style='float: left; max-width: 400px' src='/_diamond/diamond-cms/assets/images/500-admin.png' />".
            "<h1 style='color: #0A6CAEFF'>Ошибка обращения к сервису</h1>" .
            "<p style='color: #797979; padding: 20px'>Мы уже устраняем неисправность, попробуйте обновить страницу через некоторое время. Приносим извинения за временные неудобства.".
            "</p><p><a href='%s'>Вернуться на главную страницу</a></p><p>Код ошибки: %s</p></body>";

        Response::create(sprintf($content,
            getenv('BASE_URL'),
            $code
        ), Response::HTTP_INTERNAL_SERVER_ERROR)->send();

        $statService->saveStat();
    }));

}



$whoops->register();

/**
 * Routes
 * @var array $routes
 */
$dispatcher = FastRoute\simpleDispatcher(function (FastRoute\RouteCollector $r) use ($routes) {
    foreach ($routes as $route) {
        $r->addRoute($route[0], $route[1], $route[2]);
    }
});


/**
 * Dispatch
 */

$route_info = $dispatcher->dispatch($request->getMethod(), $request->getPathInfo());
switch ($route_info[0]) {
    case Dispatcher::NOT_FOUND:
        Response::create('404 Not Found', Response::HTTP_NOT_FOUND)->send();
        $stat->setErrorMessage('404-' . $code);
        break;
    case Dispatcher::METHOD_NOT_ALLOWED:
        Response::create('405 Method Not Allowed', Response::HTTP_METHOD_NOT_ALLOWED)->send();
        $stat->setErrorMessage('405-' . $code);
        break;
    case Dispatcher::FOUND:

        list($class_name,$method) = $route_info[1];
        $vars = $route_info[2];


        try {
            $object = $container->get($class_name);
            $object->beforeRun();
            $response = $object->$method($vars);
        } catch (\Core\Exceptions\ResponseException $ex) {
            $response = $ex->getResponse();
        }

        if ($response instanceof Response) {
            if ($response->getStatusCode() === 404) {
                $stat->setErrorMessage('404-' . $code);
            }
            $response->prepare($request);

            $response->send();
        }

        break;
}

$stat->setMemory($debugBar['memory']->getPeakUsage());
$stat->setElapsedTime($debugBar['time']->getRequestDuration());

$statService->saveStat();