<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 31.08.2020
 * Time: 23:20
 */

namespace Core\Helpers;


class Date
{

    /**
     * @return string
     */
    static function formatDisplay()
    {
        return "d.m.Y H:i";
    }

    static function rusMonth(int $timestamp): string
    {
        $month_name = array(
            1 => 'января',
            2 => 'февраля',
            3 => 'марта',
            4 => 'апреля',
            5 => 'мая',
            6 => 'июня',
            7 => 'июля',
            8 => 'августа',
            9 => 'сентября',
            10 => 'октября',
            11 => 'ноября',
            12 => 'декабря'
        );

        return $month_name[date('n', $timestamp)];
    }

    /**
     * @param int $time
     * @param bool $time
     * @return string
     */
    static function lastTime(int $timestamp, bool $time = true)
    {
        $month = self::rusMonth($timestamp);

        $day = date('j', $timestamp);
        $year = date('Y', $timestamp);
        $hour = date('G', $timestamp);
        $min = date('i', $timestamp);

        $date = $day . ' ' . $month . ' ' . $year . ' г.' . ($time === true ? ' в ' . $hour . ':' . $min : '');

        $dif = time() - $timestamp;

        if ($dif < 59 && $time === true) {
            return $dif . " сек. назад";
        } elseif ($dif / 60 > 1 and $dif / 60 < 59 && $time === true) {
            return round($dif / 60) . " мин. назад";
        } elseif ($dif / 3600 > 1 and $dif / 3600 < 23) {
            return round($dif / 3600) . " час. назад";
        } else {
            return $date;
        }
    }
}