<?php


namespace Core\Helpers;

use Core\Application\Loader as App;
use Symfony\Component\HttpFoundation\Request;

/**
 * Description of Url
 * @todo переместореть логику работы хелпера
 * @author Admin
 */
class Url
{
    /**
     * html ссылка
     * @param $_url
     * @param $_title
     * @param array $params
     * @param array $url_params
     * @param bool $onlyUrl
     * @return string
     */
    public static function anchor($_url, $_title, $params = [], $url_params = [], $onlyUrl = false):string
    {
        $conf = App::getInstance()->load('DI')->get(\Diamond\Config\Main::class);
        $urlSuffix = $_url . $conf->getUrl_suffix();
        if ($urlSuffix === '/' . $conf->getUrl_suffix()) {
            $urlSuffix = '/';
        }
        return anchor($urlSuffix, $_title, $params, $url_params, $onlyUrl);
    }

    /**
     * формирует строку
     * @param $_url
     * @param array $url_params
     * @return string
     */
    public static function create($_url, $url_params = []):string
    {
        $conf = App::getInstance()->load('DI')->get(\Diamond\Config\Main::class);
        $urlSuffix = $_url . $conf->getUrl_suffix();
        if ($urlSuffix === '/' . $conf->getUrl_suffix()) {
            $urlSuffix = '/';
        }
        return anchor($urlSuffix, '', [], $url_params, true);
    }


    /**
     * формирование ссылки домена
     * @param string $domain
     * @param string $url
     * @param array $data
     * @return string
     */
    public static function prepareSubDomainUrl(string $domain = '.*',string  $url = '', array $data = []):string
    {
        $host = rtrim(getenv('BASE_URL'), '/');

        $domain = rtrim($domain,'.');

        if ($domain === '.*') {
            $d2 = $host;
        } else {
            $d2 = preg_replace("~^((https?:\/\/)(www\.)?)~", '$2' . $domain . '.' , $host);
        }



        return Request::create($d2 . $url, 'GET', $data)->getUri();
    }
}