<?php

namespace Core\Exceptions;

use Symfony\Component\HttpFoundation\Response;

/**
 * Class ResponseException
 * @package Core\Exceptions
 */
class ResponseException extends BaseException
{
    protected $response;

    /**
     * ResponseException constructor.
     * @param Response $response
     */
    public function __construct(Response $response)
    {
        $this->response = $response;
        parent::__construct("Is Response!");
    }

    /**
     * @return Response
     */
    public function getResponse(): Response
    {
        return $this->response;
    }

}