<?php

namespace Core\Form\Control;

use Core\Table\Column;
use Core\Table\SimpleTable;
use Core\Repository\CrudInterface;
use Project\Models\Task\Task;
use Propel\Runtime\Collection\Collection;
use Symfony\Component\HttpFoundation\Request;

class TableCompact extends FormControl
{

    protected $repo;
    protected $callableFindFromRepository;
    protected $minPrice;
    protected $viewEmpty = false;

    function __construct(string $name, CrudInterface $repo, callable $callableFindFromRepository,float $minPrice)
    {
        $this->name = $name;
        $this->repo = $repo;
        $this->callableFindFromRepository = $callableFindFromRepository;
        $this->minPrice = $minPrice;
    }

    /**
     * @return string
     */
    function render(): string
    {
        $table = new SimpleTable($this->repo);
        $table->setViewEmpty($this->viewEmpty);
        $list = [];
        $s = 0;
        for($i=0;$i<20;$i++){

            $list[(string)$s] = number_format($s,1);
            $s =  $s+0.5;
        }

        $table->setCallableFindFromRepository($this->callableFindFromRepository);
        $table->setBottomPanel(false);
        $table->setTop_panel(true);
        $table->setTopControls(

            "<br id='tasks'/>" . $this->trHidden().

            (new Hidden("delete"))->setId("delete")->render().

            (new Button("add-task","Добавить задачу"))
            ->setClass("stdbtn btn_yellow add-task")
            ->setOnClick("return false;")
            ->render()

        );


        $table->addColumn(
            (new Column("title","Краткое описание задачи<span class=\"required_sign\">*</span>"))->setFn(function(Task $task){
                return (new Input(sprintf("task_title[%s]",$task->getId())))
                    ->setValue($task->getTitle())
                    ->setWidth(650)
                    ->render().
                    (new Hidden(sprintf("task_id[%s]",$task->getId())))
                    ->setValue($task->getId())
                    ->render()
                    ;
            })
        );
        $table->addColumn(
            (new Column("amount","Трудозатраты"))->setFn(function(Task $task) use ($list){

                return
                    (new Dropdown(sprintf("task_amount[%s]",$task->getId()),$list))
                    ->setClass("sel-amount width50")
                    ->setValue($task->getAmount())
                    ->render();
                    ;
            })
        );
        $table->addColumn(
            (new Column("price","Стоимость"))->setFn(function(Task $task){
                return (new Input(sprintf("task_price[%s]",$task->getId())))
                    ->setValue(round($task->getPrice()))
                    ->setClass("sel-price width50")
                    ->render();
            })
        );
        $table->addColumn(
            (new Column("sum","Сумма"))->setFn(function(Task $task){
                return sprintf("<span class='for-summ'>%s</span>",$task->getSumm());
            })
        );
        $table->addColumn(
            (new Column("state","Завершена"))
            ->setFn(function(Task $task){
                return (new Checkbox(sprintf("task_complete[%s]",$task->getId()),"1",$task->getComplete()>0))
                    ->setClass("sel-complete")
                    ->render();
            })
        );
        $table->addColumn(
            (new Column("delete","<!--delete-->"))
            ->setFn(function (Task $task){

                return sprintf(
                    "<a href='#tasks' class='deletebutton' data-key='%s' onclick='deleteRow(this)'>%s</a>",
                    $task->getId(),
                    "<img src='/assets/templates/admin/images/icons/trash.png'></img>"
                );
            })
        );


        return $table->render();
    }

    private function trHidden():string{
        return '<table class="task-table"><tr class="clone-hide"><td>
<input type="text" name="task_title[]" value="" autocomplete="on" style="width:650px"></td>
<td><select name="task_amount[]" class="sel-amount width50">
<option value="0.5">0.5</option>
<option value="1">1.0</option>
<option value="1.5">1.5</option>
<option value="2">2.0</option>
<option value="2.5">2.5</option>
<option value="3">3.0</option>
<option value="3.5">3.5</option>
<option value="4">4.0</option>
<option value="4.5">4.5</option>
<option value="5">5.0</option>
<option value="5.5">5.5</option>
<option value="6">6.0</option>
<option value="6.5">6.5</option>
<option value="7">7.0</option>
<option value="7.5">7.5</option>
<option value="8">8.0</option>
<option value="8.5">8.5</option>
<option value="9">9.0</option>
<option value="9.5">9.5</option>
<option value="10">10.0</option>
</select></td>
<td><input type="text" name="task_price[]" value="'.$this->minPrice.'" class="sel-price width50" autocomplete="on"></td>
<td><span class="for-summ">'.($this->minPrice/2).'</span></td><td><input type="checkbox" name="task_complete[]" value="1" class="sel-complete"></td>
<td><a href="#tasks" class="deletebutton" data-key="1" onclick="deleteRow(this)">
<img src="/assets/templates/admin/images/icons/trash.png"></a></td></tr></table>';
    }


}