<?php

namespace Core\Form\Control;

class Switchery implements ControlRenderInterface
{
    private string|null $color = null;

    public function __construct(private array $data, private bool $checked)
    {
    }

    /**
     * @param string|null $color
     * @return Switchery
     */
    public function setColor(?string $color): Switchery
    {
        $this->color = $color;
        return $this;
    }

    public function render(): string
    {
        $key = base64_encode(json_encode($this->data));
        return
            '<input ' . ($this->color !== null ? 'data-color="#' . ltrim($this->color,'#') . '"' : '') . ' data-checked-ajax="' . $key . '" class="sw-checked-ajax" type="checkbox" ' . (!$this->checked ? '' : 'checked') . '>';
    }


}