<?

namespace Core\Registry\Control;

/**
 * Description of MultiselectActionButton
 *
 * @author Admin
 */
class ButtonMultiselectAction extends \Core\Form\Control\Button
{

    protected $type = "button";
    protected $messageNotSelect = "Выберите позиции";
    protected $messageConfirm = "Точно выплнить действие?";
    protected $suffix = "_ids";

    function __construct($name, $value = 'Действие')
    {
        parent::__construct($name, $value);
    }

    function getMessageConfirm()
    {
        return $this->messageConfirm;
    }

    function setMessageConfirm($messageConfirm)
    {
        $this->messageConfirm = $messageConfirm;
        return $this;
    }

    function getMessageNotSelect()
    {
        return $this->messageNotSelect;
    }

    function setMessageNotSelect($messageNotSelect)
    {
        $this->messageNotSelect = $messageNotSelect;
        return $this;
    }

    public function render(): string
    {
         $this
                ->setClass("cancel asSubmit")
                ->setOnClick(sprintf('APL.Grid.multiselectaction(\'%s\', \'%s\' , \'%s\')', $this->messageNotSelect,
                                     $this->messageConfirm, $this->name. $this->suffix
                ));        
        return parent::render() . (new \Core\Form\Control\Hidden($this->name . $this->suffix))->render();
    }

}