<?php

namespace Core;

use Core\Concrete\RequestAwareTrait;
use Core\Concrete\UserAuthAwareTrait;
use Core\Contracts\RequestAwareInterface;
use Core\Contracts\UserAuthAwareInterface;
use Core\Form\Control\MenuItemWindowSelect;
use Repo\EntityInterface;

abstract class AdminModuleController extends ModuleController implements UserAuthAwareInterface, RequestAwareInterface
{
    use RequestAwareTrait;
    use UserAuthAwareTrait;
//    public function __construct(protected NiftyControlBuilder $controlBuilder,
//                                protected Template            $template,
//                                protected TableFactory        $tableFactory)
//    {
//
//    }

    public function formatActions(EntityInterface $entity, ?array $items = []): string
    {
        return $this->controlBuilder->buildActionMenuAdmin($items, $entity->getId())->render();
    }

    /**
     * @param string $name
     * @param string $controlName
     * @param string $id
     * @return string
     */
    public function formatRowSelect(string $name, string $controlName, string $id): string
    {
        return (new MenuItemWindowSelect($name, $controlName, $id))->render();
    }

}