<?php


namespace Core\Concrete;


use Aura\Auth\Auth;
use Aura\Auth\Status;

class LoginService extends \Aura\Auth\Service\LoginService
{
    public function forceLogin(
        Auth $auth,
        $name,
        array $data = array(),
        $status = Status::VALID
    ) {

        $started = $this->session->resume() || $this->session->start();
        if (! $started) {
            return false;
        }

        //  $this->session->regenerateId();
        $auth->set(
            $status,
            time(),
            time(),
            $name,
            $data
        );

        return $status;
    }
}