<?php declare(strict_types=1);

namespace Core\Console\Commands;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Подготовка каталогов для проекта
 *
 * @author Dmitriy
 */
class PrepareDirsCommand extends Command
{

    protected function configure()
    {
        $this->setName('prepare:dirs')
            ->setDescription('Create dirs for project');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if (!is_dir(BASEPATH . "/app/settings")) {
            mkdir(BASEPATH . "/app/settings",0775);
        }
        if (!is_dir(BASEPATH . "/app/logs")) {
            mkdir(BASEPATH . "/app/logs",0775);
        }
        if (!is_dir(BASEPATH . "/app/db")) {
            mkdir(BASEPATH . "/app/db",0775);
        }
        if (!is_dir(BASEPATH . "/app/cache")) {
            mkdir(BASEPATH . "/app/cache",0775);
        }
        if (!is_dir(BASEPATH . "/public_html")) {
            mkdir(BASEPATH . "/public_html",0775);
        }
        if (!is_dir(BASEPATH . "/public_html/upload")) {
            mkdir(BASEPATH . "/public_html/upload",0775);
        }
        $output->writeln('Prepare dirs success!');
    }
}
