<?php

namespace Core\Form\Control;

class ProgressBar implements ControlRenderInterface
{

    public function __construct(private float $progress, private string $class = 'info', private string $progressClass = 'progress')
    {
    }

    public function render(): string
    {
        return '<div class="' . $this->progressClass . '">
                        <div style="width: ' . $this->progress . '%;" class="progress-bar progress-bar-' . $this->class . '">' . $this->progress . '%
                        </div>
                    </div>';
    }

    /**
     * @param float $progress
     * @return ProgressBar
     */
    public function setProgress(float $progress): ProgressBar
    {
        $this->progress = $progress;
        return $this;
    }

    /**
     * @param string $class
     * @return ProgressBar
     */
    public function setClass(string $class): ProgressBar
    {
        $this->class = $class;
        return $this;
    }

    /**
     * @param string $progressClass
     * @return ProgressBar
     */
    public function setProgressClass(string $progressClass): ProgressBar
    {
        $this->progressClass = $progressClass;
        return $this;
    }


}