<?php

namespace Core;

use Twig\Environment;
use DebugBar\StandardDebugBar;

/**
 * Description of BaseController
 *
 * @author d.lanec
 */
abstract class BaseController implements
    \Psr\Log\LoggerAwareInterface,
    PageInterface,
    TwigAwareInterface
{

    /**
     * @var Environment
     */
    protected $twig;

    /**
     *
     * @var StandardDebugBar
     */
    protected $debugbar;

    use \Psr\Log\LoggerAwareTrait;

    public function setTwig(Environment $twig)
    {
        $this->twig = $twig;
        return $this;
    }

    public function setDebugbar(StandardDebugBar $debugbar)
    {
        $this->debugbar = $debugbar;
        return $this;
    }

    public function beforeRun(){

    }
}
