<?php

namespace Core\Form\Control;

use Symfony\Component\HttpFoundation\Request;

/**
 * Description of ImgUpload
 *
 * @author d.lanec
 */
class ImgUpload extends FormField
{

    protected $upload_dir;
    protected $max_width;
    protected $max_height;
    protected $request;
    protected $root_path;
    protected $translate = false;
    protected $previewImage = false;
    protected $previewImageSize = 50;

    /**
     *
     * @param bool $previewImage
     * @return $this
     */
    function setPreviewImage(bool $previewImage)
    {
        $this->previewImage = $previewImage;
        return $this;
    }

    /**
     *
     * @param bool $previewImage
     * @return $this
     */
    function setPreviewImageSize(int $previewImageSize)
    {
        $this->previewImageSize = $previewImageSize;
        return $this;
    }

    function getTranslate()
    {
        return $this->translate;
    }

    function setTranslate($translate)
    {
        $this->translate = $translate;
        return $this;
    }

    function translit($translit)
    {

        $str = array(
            "ё" => "e", "й" => "i", "ц" => "c", "у" => "u", "к" => "c", "е" => "e",
            "н" => "n", "г" => "g", "ш" => "sh", "щ" => "sh", "з" => "z", "х" => "h", "ъ" => "", "ф" => "f",
            "ы" => "i", "в" => "v", "а" => "a", "п" => "p", "р" => "r", "о" => "o", "л" => "l", "д" => "d",
            "ж" => "j", "э" => "e", "я" => "ya", "ч" => "ch", "с" => "s", "м" => "m", "и" => "i", "т" => "t",
            "ь" => "", "б" => "b", "ю" => "u",
            "Ё" => "E", "Й" => "I", "Ц" => "C", "У" => "U", "К" => "C", "Е" => "E",
            "Н" => "N", "Г" => "G", "Ш" => "SH", "Щ" => "SH", "З" => "Z", "Х" => "H", "Ъ" => "", "Ф" => "F",
            "Ы" => "I", "В" => "V", "А" => "A", "П" => "P", "Р" => "R", "О" => "O", "Л" => "L", "Д" => "D",
            "Ж" => "J", "Э" => "E", "Я" => "YA", "Ч" => "CH", "С" => "S", "М" => "M", "И" => "I", "Т" => "T",
            "Ь" => "", "Б" => "B", "Ю" => "U"
        );

        $str = strtr($translit, $str);

        return $str;
    }

    /**
     * транслитериация с очисткой
     * @param type $txt
     */
    function translit_file($txt)
    {
        return preg_replace('/(\_{1})\1*/i', '$1', strtolower(preg_replace('~[^A-Za-z0-9\.]~', '_', $this->translit($txt))));
    }

    function getUploadDir()
    {
        return $this->upload_dir;
    }

    function getMaxWidth()
    {
        return $this->max_width;
    }

    function getMaxHeight()
    {
        return $this->max_height;
    }

    function setUploadDir($upload_path)
    {
        $this->upload_dir = $upload_path;
        return $this;
    }

    function setMaxWidth($max_width)
    {
        $this->max_width = $max_width;
        return $this;
    }

    function setMaxHeight($max_height)
    {
        $this->max_height = $max_height;
        return $this;
    }

    /**
     * ImgUpload constructor.
     * @param string $name
     * @param string $upload_dir
     * @param Request $request
     * @param int $max_width
     * @param int $max_height
     */
    public function __construct(string $name, string $upload_dir, Request $request, int $max_width = 1000, int $max_height = 1000)
    {
        $this->setName($name);
        $this->setUploadDir($upload_dir);
        $this->setMaxHeight($max_height);
        $this->setMaxWidth($max_width);
        $this->request = $request;
        $this->root_path = $this->request->server->get("DOCUMENT_ROOT");
    }

    /**
     * @param null $img
     * @param bool $public
     * @return string
     */
    protected function getImgPath($img = null, $public = false): string
    {
        return $this->upload_dir . $img;
    }

    /**
     *
     * @return type
     */
    public function render(): string
    {

        $path = $this->getUploadDir() . $this->getValue();


        $path = preg_replace('~^(.*?\/public_html)~','',$path);

        $onclick = '';

        if ($this->previewImage === true && $this->getValue()) {

            $onclick = 'window.open(\'' . $path . '\',\'_blank\',\'width=500,height=500,status=no,resizable=no,top=200,left=\' + (window.innerWidth / 2 - 250) )';
        }

        if($onclick > ''){
            $controlHtml = sprintf(
                '<a id="' . $this->id . '" href="javascript:;" onclick="'.$onclick.'">' .
                '<img style="margin:5px; display:inline-block;border:1px solid #ccc;padding:10px;z-index: 9999;height: %s;right: 100px;max-height:%spx;max-width:%spx;" title="%s" src="%s"/>' .
                '</a>',
                $this->previewImageSize . 'px',

                $this->previewImageSize,
                $this->previewImageSize,
                $this->getValue(),
                $path,
                $this->getValue()
            );
        }
        else{
            $controlHtml = $this->getValue();
        }



        $checkBoxHtml = form_checkbox(array(
            'name' => $this->getName() . '_delete',
            'value' => 'Y'
        ));

        $hiddenHtml =  form_hidden($this->getName(), $this->getValue());

        $html = '<div style="display: flow-root">' . sprintf(
                '<span class="pull-left btn btn-primary btn-file"><span>Выбрать...</span><input onchange="var file = this.value.split(\'\\\\\');$(this).parent().find(\'span\').html(file[file.length-1])" type="file" name="%s"/></span>' .
                '<span class="pull-right">' .
                '<span>%s</span>' .
                ' %s %s удалить</span>
                <span class="pull-right">' . $this->getValue() . '</span>', $this->getName(),
                $controlHtml,
                $checkBoxHtml,
                $hiddenHtml
            ) . '</div>';

        return $html;
    }

    public function render2(): string
    {

        $path = realpath($this->getUploadDir() . $this->getValue());

        $path = str_replace('\\', '/', str_replace(realpath($this->root_path), getenv('BASE_URL'), $path));

        $onclick = '';

        if ($this->previewImage === true && $this->getValue()) {
            $onclick = "window.open('" . $path . "','width=1050,height=480,status=no,resizable=no,top=100,left=200')";
            //= "jQuery.alerts._show('" . $this->getValue() . "','<img style=\'%s\' src=\'" . $path . "\'/>',null,'alert')";
        }

        $html = '<div style="display: flow-root">' . sprintf(
                '<span class="pull-left btn btn-primary btn-file"><span>Выбрать...</span><input onchange="var file = this.value.split(\'\\\\\');$(this).parent().find(\'span\').html(file[file.length-1])" type="file" name="%s"/></span>' .
                '<span class="pull-right">' .
                '<span>%s</span>' .
                ' %s %s удалить</span><span class="pull-right">' . $this->getValue() . '</span>', $this->getName(),
                ($onclick > '' ? sprintf(
                    '<a id="' . $this->id . '" href="javascript:void(0)" onclick="' . $onclick . '">' .
                    '<img style="display:inline-block;border:1px solid #ccc;padding:10px;z-index: 9999;height: %s;right: 100px;" title="' . $this->getValue() . '" src="' . $path . '" style="max-height:' . $this->previewImageSize . 'px;max-width:' . $this->previewImageSize . 'px;"/>' .
                    '</a>',
                    'height:400px',
                    $this->previewImageSize . 'px',
                    $this->getValue()
                ) : $this->getValue()),
                //$this->getImgPath($this->getValue(),true),
                form_checkbox(array(
                    'name' => $this->getName() . '_delete',
                    'value' => 'Y'
                )), form_hidden($this->getName(), $this->getValue())
            ) . '</div>';

        return $html;
    }


    /**
     * @return string|null
     */
    public function UploadImage(): ?string
    {

        $img = $this->request->files->get($this->name);

        if ($img && $img->getPathname()) {

            if (!is_dir($this->getImgPath())) {
                mkdir($this->getImgPath(), 0777, true);
            }
            $newname = time() . '-' . ($this->getTranslate() === true ?
                    $this->translit_file($img->getClientOriginalName()) :
                    $img->getClientOriginalName());

            if (copy($img->getPathname(), $this->getImgPath($newname))) {
                $_POST[$this->name] = $newname;
                return $newname;
            }
        }

        return null;
    }

    public function deleteImage()
    {
        $delete = $this->request->request->get($this->name . '_delete');
        $image = $this->request->request->get($this->name);
        $root_path = $this->request->server->get("DOCUMENT_ROOT");

        $pathImage = $this->getImgPath() . $image;

        if ($delete  && !empty($image) && !is_dir($pathImage)) {
            $_POST[$this->name] = '';

            if(file_exists($pathImage)){
                unlink($pathImage);
            }

            return true;
        }

        return false;
    }

}
