<?php

$serviceContainer = \Propel\Runtime\Propel::getServiceContainer();
$serviceContainer->checkVersion(2);
$serviceContainer->setAdapterClass('default', 'mysql');
$manager = new \Propel\Runtime\Connection\ConnectionManagerSingle('default');
$manager->setConfiguration(array(
    'classname' => 'Propel\\Runtime\\Connection\\ProfilerConnectionWrapper',
    'dsn' => sprintf('mysql:host=%s;dbname=%s', getenv("DB_HOST"), getenv("DB_NAME")),
    'user' => getenv("DB_USER"),
    'password' => getenv("DB_PASS"),
    'attributes' =>
        array(
            'ATTR_EMULATE_PREPARES' => false,
            'ATTR_TIMEOUT' => 30,
        ),
    'settings' =>
        array(
            'charset' => 'utf8',
            'queries' =>
                array(
                    'utf8' => 'SET NAMES utf8 COLLATE utf8_unicode_ci, COLLATION_CONNECTION = utf8_unicode_ci, COLLATION_DATABASE = utf8_unicode_ci, COLLATION_SERVER = utf8_unicode_ci',
                ),
        ),
    'model_paths' =>
        array(
            0 => 'src',
            1 => 'vendor',
        ),
));
$serviceContainer->setConnectionManager($manager);
$serviceContainer->setDefaultDatasource('default');
$dbConfTemp = BASEPATH . '/app/db/loadDatabase.php';
if (!file_exists($dbConfTemp)) {
    if(!is_dir(dirname($dbConfTemp)) && !mkdir(dirname($dbConfTemp)) && !is_dir(dirname($dbConfTemp))){
        throw new RuntimeException('create db temp dir error');
    }
    file_put_contents($dbConfTemp,'<?php');
}
require_once $dbConfTemp;
