<?php
namespace Core\Registry\Factory;

use Core\Form\FormBuilder;
use Core\Registry\RepoRegisry;
use Core\Repository\PropelQueryAbstract;
use Core\Template\Template;
use Core\TwigAwareInterface;
use Symfony\Component\HttpFoundation\Request;
use Twig_Environment;
use Core\Registry, Core\Form;
/**
 * Description of newPHPClass
 *
 * @author Dmitriy
 */
class RepoRegistry implements TwigAwareInterface{
    
    protected $twig;
    
    protected $request;
    
    protected $template;
    
    protected $repoFormFactory;
    
    protected $builder;
            
    function __construct(Template $template,
			 Request $request,
			 FormBuilder $formBuilder, \Core\Form\ControlBuilder $builder){
	$this->template		 = $template;
	$this->request		 = $request;
	$this->repoFormFactory	 = $formBuilder;	
        $this->builder = $builder;
    }
    

    public function setTwig(Twig_Environment $twig){
	$this->twig = $twig;
	return $this;
    }    
    
    /**
     * 
     * @param PropelQueryAbstract $repository
     * @param type $name
     * @return RepoRegisry
     */
    public function build(PropelQueryAbstract $repository,$name): RepoRegisry {
	return new RepoRegisry(
		$repository,
		$this->repoFormFactory,
		$this->template,
		$this->twig,
		$this->request,
		$name
		
		);
    }
    
    /**
     * 
     * @param PropelQueryAbstract $repository
     * @param type $name
     * @return RepoRegisry
     */
    public function buildAdmin(PropelQueryAbstract $repository,$name): RepoRegisry {
        
        $registry = $this->build($repository, $name);
        $registry 
                ->addControl(new Registry\Control\ButtonAdd("Добавить"))
                ->addControl(new Registry\Control\ButtonEdit("Редактировать"))
                ->addControl(new Registry\Control\ButtonDelete("Удалить"))
                ->addField(new Registry\Field(new Form\Control\Submit("submit", "Сохранить")))
                ->addField(new Registry\Field($this->builder->buildCancel("back", "Отмена")))
                ;
        return $registry;
    }
    
}
