<?php

namespace Core\Form\Control;

/**
 * Description of Input
 *
 * @author Dmitriy
 */
class Input extends FormField
{

    protected $width;
    protected $type = 'text';
    protected $onFocus;
    protected $onBlur;
    protected $required = false;
    protected $autocomplete = true;

    function __construct($name, $value = null, $width = false)
    {
        $this->setName($name);
        $this->setValue($value);
        $this->setWidth($width);
    }

    /**
     * @return bool
     */
    public function getAutocomplete(): bool
    {
        return $this->autocomplete;
    }

    /**
     * @param bool $autocomplete
     * @return Input
     */
    public function setAutocomplete(bool $autocomplete): Input
    {
        $this->autocomplete = $autocomplete;
        return $this;
    }


    function setRequired($required)
    {
        $this->required = $required;
        return $this;
    }

    public function setOnFocus($txt)
    {
        $this->onFocus = $txt;
        return $this;
    }

    public function setOnBlur($txt)
    {
        $this->onBlur = $txt;
        return $this;
    }

    function getType()
    {
        return $this->type;
    }

    function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    function getWidth()
    {
        if ($this->width > 0) {
            return "width:{$this->width}px";
        }
    }

    function setWidth($width)
    {
        $this->width = $width;
        return $this;
    }

    public function render(): string
    {

        $data = array_merge([
            'name' => $this->getName(),
            'id' => $this->getId(),
            'value' => $this->getValue(),
            'class' => $this->getClass(),
            'type' => $this->getType(),
            'autocomplete' => $this->autocomplete === true ? "on" : "off",
//			'maxlength'	 => '100',
//			'size'		 => '50',
            'style' => $this->getWidth(),
            'onfocus' => $this->onFocus,
            'onBlur' => $this->onBlur
        ], $this->getAttributes());

        if ($this->required === true) {
            $data["required"] = "true";
        }

        return \form_input($data);
    }

    public function getStyle()
    {
        return $this->getWidth();
    }

}