<?php declare(strict_types=1);

namespace Core\Form\Control;

use DiamondTable\CommandFactory;

class MenuItemDelete implements MenuItemMainControlInterface
{

    public function __construct(private mixed $id)
    {
    }

    public function render(): string
    {

        return sprintf(
            '<button onclick="'."action_row({$this->id},'" . CommandFactory::ROWS_DELETE . "','Действительно удалить запись?')".
            '" class="btn demo-delete-row btn-default btn-sm"><i class="demo-pli-cross text-danger"></i></button>',
            adaptive_url([
                'fn' => 'edit',
                'id' => $this->id
            ])
        );
    }

}