<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 22.08.2020
 * Time: 13:02
 */

namespace Core\Form\Control;


class Menu implements ControlRenderInterface
{
    protected $items = [];
    protected $label;
    /**
     * @var string
     */
    protected $after;

    public function __construct(array $items, string $label = '',string $after = '')
    {
        $this->items = $items;
        $this->label = $label;
        $this->after = $after;
    }

    public function render(): string
    {
        $html_main ='';
        $items = [];
        foreach ($this->items as $item){
            if(is_a($item,MenuItemMainControlInterface::class)){
                $html_main .= $item->render();
            }
            elseif(is_a($item,ControlRenderInterface::class)){
                $items[]= $item->render();
            }
            else{
                $items[]= $item;
            }

        }

        $html = $this->after . '<div class="btn-group pull-right d-inline-flex">' . $html_main;

        if(count($items)){
            $html.= '<button class="btn btn-default dropdown-toggle dropdown-toggle-icon  btn-sm" data-toggle="dropdown" type="button" aria-expanded="false">'.
                '<i class="dropdown-caret"></i></button>';
        }

        $html .= '<ul class="dropdown-menu dropdown-menu-right">';

        // разделитель <li class="divider"></li>
        foreach ($items as $name => $link) {
            $html .= '<li>' . $link . '</li>';
        }

        $html .= '</ul>';

        $html .= '</div>';

        return $html;
    }


}