<?php

use Dotenv\Dotenv;
use League\Container\Container;
use League\Container\ReflectionContainer;
use Symfony\Component\HttpFoundation\Request;

/**
 * @var string BASEPATH
 */

if (!BASEPATH) {
    die('BASEPATH not set');
}

if(!defined('ADMIN_PATH')){
    define('ADMIN_PATH', '/admin');
}

if(!defined('ADMIN_NAME')) {
    define('ADMIN_NAME', 'Административная часть');
}

require_once BASEPATH . '/vendor/autoload.php';


/**
 * constants
 * @deprecated
 */
define('PACKPATH', BASEPATH . DIRECTORY_SEPARATOR . 'packages');


/**
 * Dotenv setup
 */
try {
    $dotenv = Dotenv::createUnsafeImmutable(BASEPATH);
    $dotenv->load();
} catch (\Dotenv\Exception\InvalidPathException $ex) {
    die('environment variables are not defined, please create .env file');
} catch (\Exception $ex) {
    die($ex->getMessage());
}

foreach (['DB_NAME', 'DB_PASS', 'DB_USER', 'BASE_URL'] as $const) {
    if (!getenv($const)) {
        die($const . ' not set!');
    }
}

require_once __DIR__ . '/config_database.php';

/**
 * Container setup
 */
$container = new Container();

$container->delegate(
    new ReflectionContainer() // Auto-wiring
);

/**
 * service providers
 */
if (!file_exists(BASEPATH . '/bootstrap/providers.php')) {
    die('please, set providers.php to /bootstrap');
}

$config = include_once BASEPATH . '/bootstrap/providers.php';

if (!isset($config['providers'])) {
    die('please, set providers in /bootstrap/providers.php');
}
$items = $config['providers'];


//routes
$routes = $viewPaths = $commandBusMap = $menuItems = $controllerPermissions =  $permissions = $consoleCommandMap = [];

/**
 * @var \Core\Contracts\ServiceProviderInterface $item
 */
foreach ($items as $item) {
    $container->addServiceProvider($item);
    $routes = array_merge($routes, $item::getRoutes());
    $commandBusMap = array_merge($commandBusMap, $item::getCommandBusMap());
    $consoleCommandMap = array_merge($consoleCommandMap, $item::getConsoleCommandMap());
    $menuItems = array_merge($menuItems, $item::getAdminNavigation());
    $controllerPermissions = array_merge($controllerPermissions, $item::getControllerPermissions());
    $viewPaths [$item::getPackageName()] = $item::getViewsPath();
    $permissions = array_merge($permissions, $item::getPermissions());
}


//Permissions
$container->share('permissions', $permissions);

//command Bus prepare
$container->share(\spaceonfire\CommandBus\CommandBus::class,
    new \spaceonfire\CommandBus\CommandBus(
        new \spaceonfire\CommandBus\Mapping\MapByStaticList($commandBusMap),
        [],
        $container
    ));

$container->share(\Core\Menu\AdminMenu::class,
    new \Core\Menu\AdminMenu($menuItems, $controllerPermissions)
);


//проход еще раз по провайдерам и заверешение инициализации
foreach ($items as $item) {
    $container->get($item)->afterInit($container);
}

foreach ($consoleCommandMap as $consoleCommand){
    $container->get(\Core\Console\Application::class)->add($container->get($consoleCommand));
}

$routes [] = [['GET', 'POST'], '/[{more:.*}]', [\Diamond\Controllers\IndexController::class, 'index']];


//Twig views
foreach ($viewPaths as $package => $path) {
    if (!is_dir($path)) {
        throw new RuntimeException(sprintf('path %s view for package not found', $path));
    }
    $container->get(\Twig\Environment::class)->getLoader()->prependPath(realpath($path), $package);
}

//Настройки Session ------------------------------------------------------------------
$lifetime = $container->get(\Diamond\Config\Main::class)->getSessionLife();
$request = $container->get(Request::class);
if (!$lifetime) {
    $lifetime = 1;
}
//@todo регулирование жизни (30дней) повышенной сессии можно вынести в настройки
//@todo Убрать отсюда в инфраструктуру
if ((int)$request->cookies->get('remember') === 1) {
    $lifetime = 24*30;
}

session_set_save_handler($container->get(\Core\Concrete\PropelSessionHandler::class), false);
session_name('SSID');
session_set_cookie_params($lifetime * 60 * 60);//перевод секунды
$newLimit = $lifetime * 60 * 60;
ini_set('session.gc_maxlifetime', $newLimit);//перевод в секунды
$newSession = (int)ini_get('session.gc_maxlifetime');
if($newLimit !== $newSession){
    throw new RuntimeException('gc_maxlifetime not modify');
}
//Настройки Session End ---------------------------------------------------------------

/**
 * add singliton
 */
\Core\Application\Loader::getInstance()->import('DI', $container);


