<?php

namespace Core\Form\Control;

use Core\Template\Template;
use Twig\Environment;

/**
 * Description of DatePicker
 *
 * @author Dmitriy
 */
class DatePickerRange extends FormField
{
    
    protected $format = 'dd/mm/yy';

    protected string|null $valueFrom = null;
    protected string|null $valueTo = null;

    function __construct(protected $nameForm, protected $nameTo)
    {
        $this->name = $this->nameForm;
    }

    public function render(): string
    {
        return '<div id="'.$this->id.'">
					                                <div class="input-daterange input-group" id="datepicker">
					                                    <input type="text" class="form-control text-left" value="'.$this->valueFrom.'" name="'.$this->nameForm.'">
					                                    <span class="input-group-addon">до</span>
					                                    <input type="text" class="form-control text-left" value="'.$this->valueTo.'" name="'.$this->nameTo.'">
					                                </div>
					                            </div>';
    }

    /**
     * @param mixed $format
     * @return DatePicker
     */
    public function setFormat(string $format)
    {
        $this->format = $format;
        return $this;
    }

    public function getValueFrom(): ?string
    {
        return $this->valueFrom;
    }

    public function setValueFrom(?string $valueFrom): DatePickerRange
    {
        $this->valueFrom = $valueFrom;
        return $this;
    }

    public function getValueTo(): ?string
    {
        return $this->valueTo;
    }

    public function setValueTo(?string $valueTo): DatePickerRange
    {
        $this->valueTo = $valueTo;
        return $this;
    }

}
