<?php

namespace Core\Form\Control;

class MenuItemWindowSelect implements MenuItemMainControlInterface
{
    public function __construct(private string $name, private string $controlName, private int $id, private string $fn = 'selectValueInWindow')
    {
    }

    public function render(): string
    {
        return '<button value="' . htmlspecialchars($this->name) . '" onclick="' . $this->fn . '(opener.document,\'' .
            $this->controlName . '\',\'' . $this->id .
            '\',this);" type="button" name="select" class="btn demo-delete-row btn-success btn-sm"><i class="demo-pli-paper-plane"></i></button>';
    }

}