<?php

namespace Core\Menu;

class AdminMenu
{

    public function __construct(private array $items, private array $controllerPermissions)
    {
    }

    /**
     * @return array
     */
    public function getItems(): array
    {
        return $this->items;
    }


    private array $cache = [];

    public function getPermissionsByUrl(string $url, string $role = null): array
    {
        if (isset($this->cache[md5($url . $role)])) {
            return $this->cache[md5($url . $role)];
        }

        $perms = [];
        foreach ($this->items as $groups) {
            foreach ($groups as $menuItem) {

                if (isset($menuItem['url'])) {
                    $perms = array_merge($perms,
                        $this->findPermission($url, $menuItem['url'], $role, $menuItem['permissions'] ?? null, $menuItem['related'] ?? null)
                    );
                }

                if(isset($menuItem['items']) && is_array($menuItem['items'])){
                    foreach ($menuItem['items'] as $sumItem){
                        if (isset($sumItem['url'])) {
                            $perms = array_merge($perms,
                                $this->findPermission($url, $sumItem['url'], $role, $sumItem['permissions'] ?? null, $sumItem['related'] ?? null)
                            );
                        }
                    }
                }

            }
        }

        foreach ($this->controllerPermissions as $urlContr => $permissions){
            $perms = array_merge($perms,
                $this->findPermission($url, $urlContr, $role, $permissions,  null)
            );
        }

        $this->cache[md5($url . $role)] = $perms;

        return $perms;
    }

    private function findPermission(string $findUrl, string $url, string $role, ?array $permissions, ?array $related): array
    {
        $perms = [];

        $permissions = array_merge($permissions??[], $this->controllerPermissions[$findUrl]??[]);

        if(!count($permissions)){
            return $perms;
        }

        $related = array_merge([ $url ], is_array($related)?$related:[]);

        if (in_array($findUrl, $related)) {
            $find = $permissions;
            if (count($find)) {
                foreach ($find as $per) {
                    if (substr($per, -4, 4) === $role) {
                        $perms[] = $per;
                    }
                }
            } else {
                $perms = array_merge($perms, $permissions);
            }
        }

        return $perms;
    }

    /**
     * @param array $items
     */
    public function setItems(array $items): void
    {
        $this->items = $items;
    }

    public function addItems(arrray $items)
    {
        $this->items = array_merge($this->items, $items);
        return $this;
    }

}