<?php

namespace Core\Form\Control;

/**
 * Description of Captcha
 *
 * @author Admin
 */
class ReCaptcha extends FormField
{

    protected $key;
    protected $secretKey;

    function __construct($name, $key, $secretKey)
    {
        $this->key = $key;
        $this->name = $name;
        $this->secretKey = $secretKey;
    }

    public function render(): string
    {
        return sprintf('<div class="g-recaptcha" data-sitekey="%s"></div><input type="hidden" value="1" name="%s" />', $this->key,  $this->name );
    }

    function getKey()
    {
        return $this->key;
    }

    function getSecretKey()
    {
        return $this->secretKey;
    }

}