<?php

namespace Core\Template;

/**
 * Description of Template
 *
 * @author Dmitriy
 */
class Template implements \Widgets\TemplateInterface
{

    protected $name;

    protected $titles = [];

    protected $block = [];

    protected $content;

    protected $styles = [];

    protected $headerStyles = [];

    protected $style;

    protected $scripts = [];

    protected $script;

    protected $pageHeader;

    protected $description;

    protected $keyWords;

    protected $pageUrl;
    /*
     * Разделитель сегментов для загаловка
     */

    public $title_separator = '|';

    /*
     * Направление загаловка
     */

    public $title_direction = 'LTR';

    protected $meta = [];

    public function __construct($name = 'blank')
    {
        $this->name = $name;
    }

    public function addMeta(string $meta)
    {
        $this->meta [] = $meta;
        return $this;
    }

    /**
     * @return string
     */
    public function getMeta(): string
    {
        return implode(',',$this->meta);
    }

    /**
     * @return mixed
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @param string $description
     * @return $this
     */
    public function setDescription(string $description)
    {
        $this->description = $description;
        return $this;
    }


    /**
     * @return string
     */
    public function getPageUrl(): string
    {
        return $this->pageUrl;
    }

    /**
     * @param string|null $pageUrl
     * @return Template
     */
    public function setPageUrl(?string $pageUrl): self
    {
        $this->pageUrl = $pageUrl;
        return $this;
    }

    /**
     * @param array $links
     * @return $this
     */
    public function addStyleLinks(array $links)
    {
        $this->styles = array_merge($this->styles, $links);
        return $this;
    }

    /**
     * @return array
     */
    public function getHeaderStyles(): array
    {
        return $this->headerStyles;
    }
    

    public function addHeaderStyleLinks(array $links)
    {
        $this->headerStyles = array_merge($this->headerStyles, $links);
        return $this;
    }

    /**
     * @param string $links
     * @return Template
     */
    public function addStyleLink(string $links): self
    {
        $this->styles [] = $links;
        return $this;
    }

    /**
     * @param array $links
     * @return Template
     */
    public function addScriptLinks(array $links): self
    {
        $this->scripts = array_merge($this->scripts, $links);
        return $this;
    }

    /**
     * @param string $links
     * @return Template
     */
    public function addScriptLink(string $links): self
    {
        $this->scripts [] = $links;
        return $this;
    }

    /**
     * @param string $style
     * @return $this
     */
    public function addStyle(string $style)
    {
        $this->style .= $style;
        return $this;
    }

    /**
     * @param string $script
     * @return $this
     */
    public function addScript(string $script)
    {
        $this->script .= $script;
        return $this;
    }

    /**
     * @return array
     */
    public function getStyles(): array
    {
        foreach ($this->styles as $k => $style) {
            if (empty($style)) {
                unset($this->styles[$k]);
            }
        }
        return $this->styles;
    }

    /**
     * @return string
     */
    public function getStyle(): ?string
    {
        return $this->style;
    }

    /**
     * @return array
     */
    public function getScripts(): array
    {
        foreach ($this->scripts as $k => $script) {
            if (empty($script)) {
                unset($this->scripts[$k]);
            }
        }
        return $this->scripts;
    }

    /**
     * @return string
     */
    public function getScript(): ?string
    {
        return $this->script;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        if ($this->title_direction === 'RTL') {
            krsort($this->titles);
        }
        $result =  trim(trim(implode(" $this->title_separator ", $this->titles)), $this->title_separator);
        return trim($result);
    }

    /**
     * @return array
     */
    public function getBlock(): array
    {
        return $this->block;
    }

    /**
     * @return string
     */
    public function getContent(): ?string
    {
        return $this->content;
    }

    /**
     * @param string $name
     * @return $this
     */
    public function setName(string $name): self
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return $this
     */
    public function clearTitle(): self
    {
        $this->titles = [];
        return $this;
    }

    /**
     * @param string|null $title
     * @return $this
     */
    public function addTitle(?string $title): self
    {
        $this->titles [] = str_replace(['"','\''],'',$title);
        return $this;
    }

    /**
     * @param string $block
     * @return $this
     */
    public function setBlock(string $block): self
    {
        $this->block = $block;
        return $this;
    }

    /**
     * @param string $content
     * @return $this
     */
    public function setContent(string $content): self
    {
        $this->content = $content;
        return $this;
    }

    /**
     * @return string
     */
    public function getPageHeader(): ?string
    {
        return $this->pageHeader;
    }

    /**
     * @param string $pageHeader
     * @return $this
     */
    public function setPageHeader(?string $pageHeader): self
    {
        $this->pageHeader = $pageHeader;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle_separator(): string
    {
        return $this->title_separator;
    }

    /**
     * @return string
     */
    public function getTitle_direction(): string
    {
        return $this->title_direction;
    }

    /**
     * @param string $title_separator
     * @return $this
     */
    public function setTitle_separator(?string $title_separator): self
    {
        $this->title_separator = $title_separator;
        return $this;
    }

    /**
     * @param string $title_direction
     * @return $this
     */
    public function setTitle_direction(?string $title_direction): self
    {
        $this->title_direction = $title_direction;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getKeyWords()
    {
        return $this->keyWords;
    }

    /**
     * @param mixed $keyWords
     * @return Template
     */
    public function setKeyWords($keyWords)
    {
        $this->keyWords = $keyWords;
        return $this;
    }

}
