<?php

namespace Core\Form;

use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Map\TableMap;
use Symfony\Component\HttpFoundation\Request;

/**
 * Description of RepoForm
 *
 * @author Dmitriy
 */
class RepoForm extends Simpleform implements \Psr\Log\LoggerAwareInterface
{
    use \Psr\Log\LoggerAwareTrait;

    protected $repository;
    protected $entity;
    protected $rowCache;
    
    protected $newLink = true;

    public function __construct(PropelQueryAbstract $repository, $name, $action = '', Request $request)
    {

        parent::__construct($name, $action, $request);

        $this->repository = $repository;

        $this->addValidationPrepareEvent([$this, "validationPrepare"]);
        $this->addValidationSuccessEvent([$this, "validationSuccess"]);
    }
    
    /**
     * Показывать ссылку на создание новой записи
     * @param type $newLink
     * @return $this
     */
    function setNewLinkInSuccess($newLink)
    {
        $this->newLink = $newLink;
        return $this;
    }

    
    public function getEntity()
    {
        return $this->entity;
    }

    public function setEntity(ActiveRecordInterface $entity)
    {
        $this->entity = $entity;
        return $this;
    }

    protected function getEntityParam($paramName, $fn = null)
    {
        $paramName = strtolower($paramName);
        
        if ( ! $this->rowCache && $this->entity->getId()) {
            
            $this->rowCache =  array_change_key_case($this->entity->toArray(TableMap::TYPE_PHPNAME));
        }

        $row = $this->rowCache ;

        if (is_callable($fn)) {
            return call_user_func($fn, $this->entity);
        }

        return isset($row[$paramName]) ? $row[$paramName] : null;
    }

    /**
     * @param Control\FormField $control
     * @param null $caption
     * @param null $validationrule
     * @param null $desc
     * @return Simpleform
     */
    public function addField(Control\FormField $control, $caption = null, $validationrule = null, $desc = null)
    {

        $value = $this->getEntityParam($control->getName(), $control->getFn());

        if ($value !== null) {
            $control->setValue($value);
        }

        return parent::addField($control, $caption, $validationrule, $desc);
    }

    /**
     * @param array $data
     * @return bool
     */
    public function validationSuccess(array $data)
    {

        try {
            
            foreach($data as $name=>$value){

                $method = "set" .$name;

                try {
                    $this->entity->{$method}($value);
                } catch (\Throwable $ex){}

            }

            
            //->fromArray($data, TableMap::TYPE_FIELDNAME);

            $this->repository->save($this->entity);
            $back = $this->createReturnLink();

            $this->addBuffer(
                    $this->getCustomMessages() . $this->createMessage(
                            "Запись успешно сохранена! " . 
                            $back . 
                            ($back > "" && $this->newLink===true ? sprintf("%s или %s", nbs(), nbs(). $this->createNewLink() ) : "") 
                            , "msgsuccess")
            );

            return true;
        } catch (\Exception $ex) {

            $this->logger->error($ex->getMessage());

            $this->addBuffer(
                    $this->createMessage("Произошла ошибка при сохранении записи")
            );

            $this->addBuffer($this->generateForm());    
            
            return false;
        }
    }
    
    
    public function validationPrepare(array $data)
    {
        
        return $data;
    }

}