<?php

namespace Core\Form\Control;

/**
 * Description of Button
 *
 * @author Dmitriy
 */
class Submit extends Button
{

    protected $type = 'submit';

    public function render(): string
    {
        return \form_button([
            'value' => $this->getValue(),
            'type' => $this->type,
            'name' => $this->getName(),
            'content' => $this->getValue(),
            "class" => $this->getClass(),
            'onclick' => $this->getOnClick()
        ]);
    }

}