<?php declare(strict_types=1);

namespace Core\Form\Control;

class MenuItemEdit implements MenuItemMainControlInterface
{

    protected string $classIcon = 'demo-psi-pen-5';

    public function __construct(private mixed $id, private ?string $url = null)
    {
    }

    public function setClassIcon(string $classIcon): MenuItemEdit
    {
        $this->classIcon = $classIcon;
        return $this;
    }

    public function render(): string
    {
        return sprintf(
            '<a href="%s" class="btn btn-default btn-sm"><i class="'.$this->classIcon.'"></i></a>',
            !$this->url ? adaptive_url([
                'fn' => 'edit',
                'id' => $this->id
            ]): $this->url
        );
    }

}