<?php

namespace Core\Form\Control;


class MenuItemWindow implements ControlRenderInterface
{

    private $url;
    private $label;
    private $icon;

    public function __construct(string $url, string $label, string $icon = '')
    {
        $this->url = $url;
        $this->label = $label;
        $this->icon = $icon;
    }

    public function render(): string
    {
        $popup = "window.open('" . $this->url . "', '" . $this->label . "','width=1050,height=480,status=no,resizable=no,top=100,left=200')";
        return
            '<a onclick="' . $popup . '" href="javascript:void(0)">' . ($this->icon ? '<i class="' . $this->icon . '"></i> ' : '') . $this->label . '</a>';
    }

}