<?php


namespace Core\Helpers;

use Symfony\Component\Validator\Validation;

/**
 * Class Email
 * @package Core\Helpers
 */
class Email
{
    /**
     * @param string $email
     * @return bool
     */
    public static function isValid(string $email): bool
    {
        $validator = Validation::createValidator();

        $results = $validator->validate($email, new \Symfony\Component\Validator\Constraints\Email());

        return $results->count()===0;
    }
}