<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 24.08.2020
 * Time: 23:30
 */

namespace Core\Security;


use Casbin\Enforcer;
use Core\Exceptions\BaseException;

/**
 * права доступа
 * Class Access
 * @package Core\Security
 */
class Access
{

    protected $enforcer;

    static private $BASE_CONF = BASEPATH . '/app/access/basic.conf';

    /**
     * Access constructor.
     * @throws BaseException
     * @throws \Casbin\Exceptions\CasbinException
     */
    public function __construct()
    {
        if(!file_exists(self::$BASE_CONF) || !file_exists(BASEPATH . '/app/access/rules.csv')){
            throw new BaseException('Files rules not set');
        }

        $this->enforcer = new Enforcer(self::$BASE_CONF, BASEPATH . '/app/access/rules.csv');
    }



    /**
     * @param string $domain
     * @param string $user
     * @param string $role
     * @param string $object
     * @param string $operation
     * @return bool
     * @throws \Casbin\Exceptions\CasbinException
     */
    public function isAccess(string $domain, string $user, string $object, string $operation): bool
    {

        try {
            return $this->enforcer->enforce($user, $domain, $object, $operation);
        } catch (\TypeError $exception) {
            throw new BaseException('error access rules: ' . $exception->getMessage());
        }
    }
}