<?php


namespace Core\Form\Control;


use Diamond\Helpers\Form;

class WindowPopUp extends FormField
{

    /**
     * @var string
     */
    protected $name;

    protected $url;

    protected $caption;

    /**
     * WindowPopUp constructor.
     * @param string $name
     * @param string $url
     * @param string $caption
     */
    public function __construct(string $name,string $url, string $caption)
    {
        $this->name = $name;
        $this->url = $url;
        $this->caption = $caption;
    }


    /**
     * @return string
     */
    public function render(): string
    {
        return
            '<a onclick="window.open(\''. $this->url
            .'\',\''.$this->name.'\',\'width=1050,height=480,status=no,resizable=no,top=100,left=200\')" href="javascript:void(0)" >' .
            $this->caption.
            '</a>'
        ;
    }

}