<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 22.08.2020
 * Time: 13:02
 */

namespace Core\Form\Control;


class Menu implements ControlRenderInterface
{
    protected $items = [];
    protected $label;
    /**
     * @var string
     */
    protected $after;

    public function __construct(array $items, string $label,string $after = '')
    {
        $this->items = $items;
        $this->label = $label;
        $this->after = $after;
    }

    public function render(): string
    {
        $html =
            $this->after .
            '<div class="dropdown"><div class="button-action"><span>' .
            $this->label
            . '<span class="arrow"></span></span></div>';

        $html .= '<ul>';

        foreach ($this->items as $name => $link) {
            $html .= '<li>' . $link . '</li>';
        }

        $html .= '</ul></div>';

        return $html;
    }


}