<?php


namespace Core\Form\Control;


use Diamond\Helpers\Form;

class WindowSelect extends FormField
{
    /**
     * @var string|null
     */
    protected $caption;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string|null
     */
    protected $value;

    protected $url;

    protected $class = 'smallinput';

    /**
     * WindowSelect constructor.
     * @param string $name
     * @param string $url
     * @param string $caption
     */
    public function __construct(string $name,string $url,string  $caption)
    {
        $this->name = $name;
        $this->caption = htmlspecialchars($caption);
        $this->url = $url;
    }


    /**
     * @return string
     */
    public function render(): string
    {
        return
            '<input name="'.$this->name.'" type="hidden" value="'.$this->value.'" />'.
            '<input class="'.$this->class.'" type="text" name="'.$this->name.'_caption"  readonly value="'.$this->caption .'" />'
             . '<a onclick="window.open(\''. $this->url
            .'\',\''.$this->name.'\',\'width=1050,height=480,status=no,resizable=no,top=100,left=200\')"  class="window-select" href="javascript:void(0)" >' .
            '<span></span></a>'
           // '<a>'.Form::buildIcon('trash').'</a>'
        ;
    }

}