<?

namespace Core\Form\Control;

/**
 * Description of Checkbox
 *
 * @author Admin
 */
class Checkbox extends Input
{

    protected $checkValue;

    protected $noCheckValue;

    protected $checked = false;

    protected $type = 'checkbox';

    /**
     * @var bool если одиночный контрол то генерит скрытое поле для дефолтного значения
     */
    protected $single = false;

    /**
     * @var string
     */
    protected $caption;

    /**
     * Checkbox constructor.
     * @param string $name
     * @param string $checkValue
     * @param bool $width
     * @param string|null $noCheckValue
     */
    public function __construct(string $name, string $checkValue, $width = false, string $noCheckValue = null)
    {
        parent::__construct($name, null, $width);
        $this->checkValue = $checkValue;
        $this->noCheckValue = $noCheckValue;
    }

    /**
     * @param string $caption
     * @return Checkbox
     */
    public function setCaption(string $caption): Checkbox
    {
        $this->caption = $caption;
        return $this;
    }


    /**
     * @param bool $single
     * @return Checkbox
     */
    public function setSingle(bool $single): Checkbox
    {
        $this->single = $single;
        return $this;
    }


    public function getChecked(): bool
    {
        return $this->checked;
    }

    /**
     * @param bool $checked
     * @return Checkbox
     */
    public function setChecked(bool $checked): self
    {
        $this->checked = $checked;
        return $this;
    }

    /**
     * @return string
     */
    public function render(): string
    {

        if ($this->value && (string)$this->checkValue === (string)$this->value) {
            $this->checked = true;
        } elseif($this->value) {
            $this->checked = false;
        }
        

        if ($this->noCheckValue === null) {
            $this->single = true;
        }

        return

            ($this->single === false ? \form_input([
                'type' => 'hidden',
                'name' => $this->name,
                'id' => $this->id,
                'value' => (string)$this->noCheckValue
            ]) : '') .
            \form_checkbox(array_merge([
                'name' => $this->getName(),
                'id' => $this->getId(),
                'value' => $this->checkValue,
                'class' => $this->getClass(),
                'type' => $this->getType(),
//			'maxlength'	 => '100',
//			'size'		 => '50',
                'style' => $this->getWidth(),
                'onfocus' => null,//$this->onFocus,
                'onBlur' => $this->onBlur
            ], $this->getAttributes()), $this->name, $this->checked). ($this->caption ? $this->caption . ' ' : '');
    }


}
