<?php
namespace Core\Console\Commands;

use Diamond\Models\Session\Base\Session;
use Diamond\Models\Session\Base\SessionQuery;
use Diamond\Models\Session\Map\SessionTableMap;
use Propel\Runtime\Connection\ConnectionFactory;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Адаптация картинок произврдителей
 *
 * @author Admin
 */
class SessionCommand extends Command
{


    protected function configure()
    {
        $this->setName('tools:clear-old-session')
            ->setDescription('Clear old session data');
    }


    /**
     * 
     * @param InputInterface $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {

        $connect = \Propel\Runtime\Propel::getConnection(SessionTableMap::DATABASE_NAME);

        $query = $connect->prepare('DELETE
FROM _sessions
WHERE time < UNIX_TIMESTAMP(NOW()) - lifetime');

        if(!$query->execute()){
            $output->writeln("Clear session data - error!");
            return;
        }
        else{
            $output->writeln("Clear session data - success! Delete rows " . (int) $query->rowCount() );
        }

    }

}