<?php

namespace Core;

/**
 * Description of IniConfig
 *
 * @author Dmitriy
 */
abstract class IniConfig
{

    protected $data = [];
    protected $loaded = false;

    protected static $cacheData = [];

    protected function getPath()
    {
        return BASEPATH . '/app/settings/' . $this->getFileName();
    }

    public function __construct()
    {
        $iniPath = $this->getPath();
        $dir = BASEPATH . '/app/settings/';

        if(!is_dir($dir) && !mkdir($dir)){
            throw new \RuntimeException('Not exist dir for settings: ' . $dir);
        }

        $data = $this->getDataFromFile($iniPath);

        foreach ($data as $k => $v) {
            if (property_exists($this, $k)) {
                $this->{$k} = $v;
            }
        }


        //$this->loaded = true;
    }

    /**
     * @param string $v
     * @return string|null
     */
    protected function decodeValue(string $v)
    {
        $extractValue = base64_decode($v);
        if (strpos($extractValue, ":{") !== false) {
            return unserialize($extractValue);
        } else {
            return $extractValue;
        }

        return null;
    }

    /**
     * @param string $file
     * @return array
     */
    private function getDataFromFile(string $file): array
    {
        if (isset(static::$cacheData[$file])) {
            return static::$cacheData[$file];
        }

        if (!file_exists($file)) {
            return [];
        }
        $data = [];

        $dataSource = parse_ini_file($file);

        foreach ($dataSource as $k => $v){
            $data[$k] = $this->decodeValue($v);
        }


        static::$cacheData[$file] = $data;

        return $data;
    }

    /**
     * сохраняем в файл
     *
     * @param array $data
     * @return boolean
     */
    function save(array $data): bool
    {

        $tmp = '';

        $currentData = $this->getDataFromFile($this->getPath());

        $saveData = array_merge($currentData, $data);

        foreach ($saveData as $key => $val) {

            if (!is_string($val)) {
                $val = serialize($val);
            }

            $val = base64_encode($val);

            $tmp .= "$key = \"" . addslashes($val) . "\"\n";
        }

        file_put_contents($this->getPath(), $tmp);

        return true;
    }

    abstract protected function getFileName();
}