<?php

namespace Core\Contracts;


use Psr\Container\ContainerInterface;

interface ServiceProviderInterface
{
    /**
     * путь как шаблонам пакета
     * @return string
     */
    public static function getViewsPath(): string;

    /**
     * настройка роутинга
     * @return array
     */
    public static function getRoutes(): array;


    /**
     * @return string
     */
    public static function getPackageName(): string;

    /**
     * @return string
     */
    public static function getCommandBusMap(): array;


    public function afterInit(ContainerInterface $container): void ;
}