<?php

namespace Core\Form\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Description of CaptchaValidator
 *
 * @author Admin
 */
class CaptchaValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint)
    {
        
        $phrase =  $constraint->getCaptcha()->getOldCode();
        if ($phrase != $value) {
            $this->context->buildViolation($constraint->message)
                ->setParameter('{{ string }}', $phrase)
                ->addViolation();
        }
    }
}
