<?php

namespace Core\Form;

use Core\Repository\PropelQueryAbstract;
use Core\TwigAwareInterface;
use Core\TwigAwareTrait;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Symfony\Component\HttpFoundation\Request;
use Core\Form\ControlBuilder;

/**
 * Description of FormBuilder
 *
 * @author Admin
 */
class FormBuilder implements TwigAwareInterface, LoggerAwareInterface
{
    use TwigAwareTrait;

    use LoggerAwareTrait;

    protected $request;
    protected $class = "stdform stdform2";
    protected $builder;

    /**
     * FormBuilder constructor.
     * @param Request $request
     * @param \Core\Form\ControlBuilder $builder
     */
    public function __construct(Request $request, ControlBuilder $builder)
    {
        $this->request = $request;
        $this->builder = $builder;
    }

    /**
     * @param \Core\IniConfig $config
     * @param string $name
     * @param string|null $action
     * @return SettingsForm
     */
    public function buildSettingsForm(\Core\IniConfig $config, string $name, string $action = null)
    {
        return (new SettingsForm($config, $name, $action, $this->request))
            ->setTwig($this->twig)
            ->setClass($this->class)
            ->addControl(
                $this->builder->buildSubmitButton("submit", "Сохранить изменения")
            );
    }

    /**
     * @param string $name
     * @param string|null $action
     * @return Simpleform
     */
    public function buildSimpleValidationForm(string $name, string $action = null): Simpleform
    {
        return (new Simpleform($name, $action))
            ->setTwig($this->twig)
            ->setClass($this->class);
    }

    /**
     * @param PropelQueryAbstract $repository
     * @param string $name
     * @param string|null $action
     * @return RepoForm
     */
    public function buildRepoValidationForm(PropelQueryAbstract $repository, string $name, string $action = null): RepoForm
    {

        $form = (new RepoForm($repository, $name, $action, $this->request))
            ->setTwig($this->twig)
            ->setClass($this->class);
        $form->setLogger($this->logger);

        return $form;
    }

}