<?php


namespace Core;

/**
 * Class AbstractModuleParams
 * @package Core
 */
class AbstractModuleParams
{

    protected $tpl = 'default';

    /**
     * @return mixed
     */
    public function getTpl():string
    {
        return $this->tpl;
    }


    /**
     * @param array $params
     */
    public function buildParams(array $params = [])
    {
        foreach ($params as $param => $value) {

            foreach ($params as $param => $value) {
                if (!property_exists($this, $param)) {
                    throw new \RuntimeException(sprintf("property '%s' not found in module '%s'", $param, get_class($this)));
                }
                $this->{$param} = $value;
            }
        }
    }

}