<?php

namespace Core\Table;

/**
 * Description of Column
 *
 * @author Dmitriy
 */
class Column
{

    protected $name;

    protected $title;

    protected $width;

    protected $hidden;

    protected $fn;

    protected $align;

    protected $key;

    protected $index;

    protected $sort;

    protected $search;

    protected $stype;

    protected $editOptions;

    protected $summ;

    /**
     * 
     * @param type $name
     * @param type $title
     * @param type $width
     * @param type $hidden
     * @param type $key
     * @param type $align
     */
    function __construct($name, $title, $width = 20, $hidden = false, $key = false, $align = 'left')
    {
        $this->setName($name);
        $this->setTitle($title);
        $this->setWidth($width);
        $this->setAlign($align);
        $this->setHidden($hidden);
        $this->setKey($key);
    }

    function getSort()
    {
        return $this->sort;
    }


    function setSort($sort)
    {
        $this->sort = $sort;
	return $this;
    }

    function getSumm()
    {
        return $this->summ;
    }

    function setSumm($summ)
    {
        $this->summ = $summ;
	return $this;
    }

    function getStype()
    {
        return $this->stype;
    }

    function getEditOptions()
    {
        return $this->editOptions;
    }

    function setStype($stype)
    {
        $this->stype = $stype;
        return $this;
    }

    function setEditOptions($editOptions)
    {
        $this->editOptions = $editOptions;
        return $this;
    }

    function getIndex()
    {
        return $this->index;
    }

    function setIndex($index)
    {
        $this->index = $index;
        return $this;
    }

    function getKey()
    {
        return $this->key;
    }

    function setKey($key)
    {
        $this->key = $key;
	return $this;
    }

    function getName()
    {
        return $this->name;
    }

    function getTitle()
    {
        return $this->title;
    }

    function getWidth()
    {
        return $this->width;
    }

    function getHidden()
    {
        return $this->hidden;
    }

    function getFn()
    {
        return $this->fn;
    }

    function getAlign()
    {
        return $this->align;
    }

    function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    function setWidth($width)
    {
        $this->width = $width;
        return $this;
    }

    function setHidden($hidden)
    {
        $this->hidden = $hidden;
        return $this;
    }

    function setFn($fn,$method = null)
    {
        $this->fn = !$method ? $fn : [$fn,$method];
        return $this;
    }

    function setAlign($align)
    {
        $this->align = $align;
        return $this;
    }

    function getSortable()
    {
        return $this->sort;
    }

    function setSortable($sort)
    {
        $this->sort = $sort;
        return $this;
    }

    function getSearch()
    {
        return $this->search;
    }

    function setSearch($search)
    {
        $this->search = $search;
        return $this;
    }
}
