<?php

namespace Core\Form\Control;

/**
 * Description of Button
 *
 * @author Dmitriy
 */
class Button extends FormControl
{

    protected $onClick;
    protected $type = "submit";

    function __construct($name, $value)
    {
        $this->setName($name);
        $this->setValue($value);
    }

    function getType()
    {
        return $this->type;
    }

    function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    function getOnClick()
    {
        return $this->onClick;
    }

    function setOnClick($onClick)
    {
        $this->onClick = $onClick;

        return $this;
    }

    public function render(): string
    {
        return \form_button(array_merge([
            'name' => $this->getName(),
            'type' => $this->getType(),
            'content' => $this->getValue(),
            'class' => $this->getClass(),
            'onclick' => $this->getOnClick()
        ], $this->getAttributes()));
    }

}
