<?php
namespace Core\Console\Commands;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Description of HelloWorldCommand
 *
 * @author Dmitriy
 */
class InstallPackagesCommand extends Command{

    protected function configure(){
	$this->setName('prepare:packages')
		->setDescription('Copy packages migration and assets');
    }

    protected function execute(InputInterface $input, OutputInterface $output){
	$finder = \Symfony\Component\Finder\Finder::create();

        //перекидываем миграции
	try{
	    
	    $iterator = $finder->files()->in(BASEPATH . "/vendor/*/*/db/*");

	    $this->copyFiles($iterator, $output);
	    
	} catch(\Exception $exc){
	    $output->writeln("nothing to install from vendor");
	}
	
	

    }
    
    protected function copyFiles($iterator,OutputInterface $output){
	foreach($iterator as $file){
            
            $fileSystem = new \Symfony\Component\Filesystem\Filesystem();

            $fileDir = preg_replace("~(.*\/)(.*?)$~", "$2", $file->getPath());

            //создаем каталог файла если его нет
            $dir = BASEPATH . '/app/db/'.$fileDir.'/';

            if(!is_dir($dir)){
                $fileSystem->mkdir($dir);
            }

            //копируем туда файлы
            $fileSystem->copy($file->getRealpath(), $dir . $file->getRelativePathname() );
            
            $output->writeln(sprintf("copy file %s success!",$fileDir.'/'. $file->getRelativePathname()));
	}	
    }
}
