<?php

use JBZoo\Utils\Url;
use Symfony\Component\HttpFoundation\Request;

/**
 * @param string $_url
 * @param string $_title
 * @param array $params
 * @param array $url_params
 * @param bool $onlyUrl
 * @return string
 */
function anchor(string $_url, string $_title, array $params = [], array $url_params = [], bool $onlyUrl = false): string
{

    if (strpos($_url, '://') === false && strpos($_url,'javascript') ===false ) {
        $url = Request::create($_url, 'GET', $url_params)->getRequestUri();
    } else {
        $url = $_url;
    }

    extract($params);
    if ($onlyUrl === true) {
        return $url;
    }

    return sprintf('<a href="%s"%s%s%s%s>%s</a>', $url,
        isset($title) ? ' title="' . $title . '"' : '',
        isset($class) ? ' class="' . $class . '"' : '',
        isset($onclick) ? ' onclick="' . $onclick . '"' : '',
        isset($target) ? ' target="' . $target . '"' : '',
        $_title
    );
}

/**
 * Форматирует ссылку в SEO формате
 * @param string $uri
 * @param string $alias
 * @param string $title
 * @param string $attributes
 * @param array $params
 * @param bool $onlyUrl
 * @return string
 */
function anchorSeo(string $uri = '', string $alias = '', string $title = '', array $attributes = [], array $params = array(), bool $onlyUrl = false)
{
    if (!empty($alias)) {
        return anchor($uri . '/' . $alias, $title, $attributes, $params, $onlyUrl);
    }

    return anchor($uri, $title, $attributes, $params, $onlyUrl);
}

/**
 * @param array $params
 * @param array $ignore
 * @return string
 */
function adaptive_url(array $params = [], array $ignore = []): string
{
    $params = array_merge(Request::createFromGlobals()->query->all(), $params);
    return Url::delArg($ignore, Url::addArg($params));
}

/**
 * @param string $name
 * @return string
 */
function input_get(string $name): ?string
{
    return Request::createFromGlobals()->query->get($name);
}

/**
 * @param string $name
 * @return string
 */
function input_get_int(string $name): ?int
{
    $value = Request::createFromGlobals()->query->get($name);
    return $value ? (int) $value : null;
}

/**
 * @param string $name
 * @return string
 */
function input_post(string $name): ?string
{
    return Request::createFromGlobals()->request->get($name);
}

/**
 * @return string
 */
function current_url(): string
{
    return str_replace(Url::root(), '', Url::current());
}

/**
 * @return string
 */
function site_url(): string
{
    return Url::root();
}

/**
 * @param int $n
 * @return string
 */
function nbs($n = 1): string
{
    return str_repeat('&nbsp;', $n);
}
